package gov.va.med.mhv.vitals.repository;

import gov.va.med.mhv.vitals.model.BodyWeightReading;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BodyWeightReadingRepository extends JpaRepository<BodyWeightReading, Long>{
	
    @Query("select a from BodyWeightReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<BodyWeightReading>  getBWReadingsForUser(@Param ("userprofileid") Long userprofileid);
    
    @Query("select a from BodyWeightReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<BodyWeightReading>  getDashBoardBWReadingsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);



}
